package com.hero.objects.characteristics;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.CharAffectingObject;
import com.hero.objects.powers.Power;
import com.hero.util.Constants;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Ego extends Characteristic {

    private static String xmlID = "EGO";

    public Ego(Element template) {
        super(template, Ego.xmlID);
    }

    @Override
    public int getType() {
        return Constants.EGO;
    }

    @Override
    public String getDisplayNotes() {
    	if (HeroDesigner.getActiveTemplate().is6E()) {
        	return "";
        }
        double ecv1 = 0;
        double ecv2 = 0;
        if (HeroDesigner.getActiveHero() != null) {
            baseLevel = origBaseLevel;
            doubleBase = origBaseLevel;
            for (int i = 0; i < HeroDesigner.getActiveHero()
                    .getCharacteristics().size(); i++) {
                Characteristic ch = (Characteristic) HeroDesigner
                        .getActiveHero().getCharacteristics().get(i);
                if (ch.getEcvIncreaseLevels() > 0 && ch.getEcvIncrease() != 0) {
                    double mult = ch.getPrimaryValue() * ch.getEcvIncrease()
                            / ch.getEcvIncreaseLevels();
                    ecv1 += mult;
                    mult = ch.getSecondaryValue() * ch.getEcvIncrease()
                            / ch.getEcvIncreaseLevels();
                    ecv2 += mult;
                }
            }
            for (int i = 0; i < HeroDesigner.getActiveHero().getPowers().size(); i++) {
                if (HeroDesigner.getActiveHero().getPowers().get(i) instanceof Power) {
                    CharAffectingObject ch = (CharAffectingObject) HeroDesigner
                            .getActiveHero().getPowers().get(i);
                    if (ch.getEcvIncreaseLevels() > 0
                            && CharAffectingObject.checkFigured(ch, getType())
                            && ch.getEcvIncrease() > 0) {
                        double mult = ch.getLevels() * ch.getEcvIncrease()
                                / ch.getEcvIncreaseLevels();
                        if (ch.getAffectPrimary()) {
                            ecv1 += mult;
                        }
                        ecv2 += mult;
                    }
                }
            }
            for (int i = 0; i < HeroDesigner.getActiveHero().getEquipment()
                    .size(); i++) {
                if (HeroDesigner.getActiveHero().getEquipment().get(i) instanceof Power) {
                    CharAffectingObject ch = (CharAffectingObject) HeroDesigner
                            .getActiveHero().getEquipment().get(i);
                    if (ch.getEcvIncreaseLevels() > 0
                            && CharAffectingObject.checkFigured(ch, getType())
                            && ch.getEcvIncrease() > 0) {
                        double mult = ch.getLevels() * ch.getEcvIncrease()
                                / ch.getEcvIncreaseLevels();
                        if (ch.getAffectPrimary()) {
                            ecv1 += mult;
                        }
                        ecv2 += mult;
                    }
                }
            }
        }
        return "ECV: " + Rounder.roundHalfUp(ecv1)
                + (ecv1 == ecv2 ? "" : "/" + Rounder.roundHalfUp(ecv2));
    }
}